///////////////////
// containers.js //
/////////////////////////
// Version: 2003.05.09 //
//////////////////////////////////////////////
//                                          //
//     JavaScript Container Objects         // 
//                                          //
//////////////////////////////////////////////

function rect(x, y, w, h)
{
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
}

///////////////
// Position  //
///////////////
function Position(X,Y)
{
	if (typeof X != "number" || typeof Y != "number" || Position.arguments.length != 2)
	{
		alert("The Position Object must be passed 2 numbers as parameters.  Object not created.");
		return null;
	}

	this.x = X;
	this.y = Y;
}
Position.prototype.getX = PositionGetX;
Position.prototype.getY = PositionGetY;
Position.prototype.setX = PositionSetX;
Position.prototype.setY = PositionSetY;
Position.prototype.distance = PositionDistance;
Position.prototype.slope = PositionSlope;

function PositionSlope(posRef)
{
	return (this.y-posRef.getY())/(this.x-posRef.getX());
}

function PositionGetX()
{
	return this.x;
}

function PositionGetY()
{
	return this.y;
}

function PositionSetX(X)
{
	this.x = X;
}

function PositionSetY(Y)
{
	this.y = Y;
}

function PositionDistance(posRef)
{
	return Math.sqrt( Math.pow((this.x - posRef.x),2) + Math.pow((this.y - posRef.y),2) );
}

///////////////
// Dimension //
///////////////
function Dimension(w,h)
{
	if (typeof w != "number" || typeof h != "number" || Dimension.arguments.length != 2)
	{
		alert("The Dimension Object must be passed 2 numbers as parameters.  Object not created.");
		return null;
	}

	this.width = w;
	this.height = h;
}
Dimension.prototype.setWidth = DimensionSetWidth;
Dimension.prototype.setHeight = DimensionSetHeight;
Dimension.prototype.getWidth = DimensionGetWidth;
Dimension.prototype.getHeight = DimensionGetHeight;

function DimensionSetHeight(h)
{
	this.height = h;
}

function DimensionSetWidth(w)
{
	this.width = w;
}

function DimensionGetHeight(h)
{
	return this.height;
}

function DimensionGetWidth(w)
{
	return this.width;
}

/////////////////////
//      Queue      //
/////////////////////
function Queue() 
{
	this.arr = new Array();
}
Queue.prototype.enqueue = function (val){this.arr.unshift(val)};
Queue.prototype.dequeue = function (){return this.arr.pop()};
Queue.prototype.getLength = function (){return this.arr.length};
Queue.prototype.removeFirst = function (val){for (var i=this.arr.length-1;i>=0;i--) { if (this.arr[i]==val) {var retVal = this.arr[i];_Splice(this.arr,i,1);return retVal} } return null;};
Queue.prototype.removeLast = function (val){for (var i=0;i<this.arr.length;i++) { if (this.arr[i]==val) {var retVal = this.arr[i];_Splice(this.arr,i,1);return retVal} } return null;};
Queue.prototype.remove = Queue.prototype.removeLast;

////////////////
// Hash Table //
////////////////
function HashTable()
{
	this.obj = new Object();
	return this;
}

HashTable.prototype.insert = HashTable.prototype.put = function(id,val){
	this.obj[id] = val;
}

HashTable.prototype.retrieve = HashTable.prototype.get = function(id){
	var retVal = this.obj[id];
	if (!retVal) retVal = null;
	return retVal;
}

HashTable.prototype.remove = function(id){
	this.obj[id] = null;
}

HashTable.prototype.clear = function(){
	this.obj = new Object();
}

HashTable.prototype.getLength = function(){
	var count = 0;
	for (var i in this.obj) if (this.obj[i]) count++;
	return count;
}

HashTable.prototype.getKeys = function(){
	var retVal = new Array();
	for (var i in this.obj) if (this.obj[i]) retVal[retVal.length] = i;
	return retVal;
}

HashTable.prototype.toString = function(){
	var retVal = new Array();
	for (var i in this.obj) if (this.obj[i]) retVal[retVal.length] = i + ":" + this.obj[i];
	return retVal.toString().replace(/\,/g,"\n");
}

HashTable.prototype.toHTML = function(){
	var retVal = new Array();
	for (var i in this.obj) if (this.obj[i]) retVal[retVal.length] = i + ":" + this.obj[i];
	return retVal.toString().replace(/\,/g,"<br>");
}

///////////////
//  VarStore //
///////////////
///////////////////////////////////////////////////////////
//    A VarStore is an object that you can use to store  //
//    name, value pairs.  It is a lot like creating a    //
//    JavaScript variable, except the values you save in //
//    your VarStore object have to be strings.           //
//                                                       //
//    The main motivation for having a VarStore object   //
//    is its ability to dump all of its contents into    //
//    a single string.  I know that doesn't sound all    //
//    that exciting at first, but just hang on there     //
//    cowboy.  You can take the string representation    //
//    of your VarStore and save it as a single cookie,   //
//    or store it in a database as a single value.       //
//    Believe me, this comes in handy.  What?  Still     //
//    not convinced?  Maybe I'll try an example.         //
//                                                       //
//    Suppose you have to save BeenTheres for a whole    //
//    bunch of pages, and those BeenTheres need to       //
//    exist between multiple user sessions in the        //
//    courseware.  You will need to save the             //
//    BeenTheres somewhere so the courseware can recall  //
//    them later.  You could save the values in a        //
//    database via ASP pages.  The BeenTheres could be   //
//    stored as individual records in the database,      //
//    requiring code to manage the numerous number       //
//    of entries in the database, and the many           //
//    individual calls for setting and getting the       //
//    BeenThere values.                                  //
//                                                       //
//    Alternatively, you could manage all your           //
//    BeenTheres in a VarStore, and when it comes time   //
//    to pass the values to the server to be saved,      //
//    you can dump the contents of the VarStore into     //
//    a single string value.  Now all you have to do     //
//    to save all of your BeenTheres is save this single //
//    string to the database.  This GREATLY simplifies   //
//    the ASP code, as it will now only have to manage   //
//    passing the value of a single record in the        //
//    database back and forth between server and client. //
///////////////////////////////////////////////////////////
//                                                       //
// Create: 			myVarStore = new VarStore();         //
// Set Variable:	myVarStore.setValue("bt0","true");   //
// Get Value:		myVarStore.getValue("bt0");          //
// Clear Out Store:	myVarStore.clear();                  //
// Remove Variable:	myVarStore.remove("bt0");            //
// Variable Exists:	myVarStore.tokenExists("bt0");       //
// Load from String:myVarStore.load(someString);         //
// Dump to String:	myVarStore.dump();                   //
//                                                       //
///////////////////////////////////////////////////////////

// Low ASCII characters were chosen, since they are rarely used.
var VARSTORE_SEPARATOR_1 = String.fromCharCode(1);
var VARSTORE_SEPARATOR_2 = String.fromCharCode(2);
 
function VarStore(sep1, sep2)
{ 
	//this.tokenArray = new Array();
	this.hashTable = new HashTable();
	this.dirty = false;
	this.separator1 = sep1;
	this.separator2 = sep2;
	if (this.separator1 == null) this.separator1 = VARSTORE_SEPARATOR_1;
	if (this.separator2 == null) this.separator2 = VARSTORE_SEPARATOR_2;
}
VarStore.prototype.getLength = VarStoreGetLength;
VarStore.prototype.clear = VarStoreClear;
VarStore.prototype.dump = VarStoreDump;
VarStore.prototype.load = VarStoreLoad;
VarStore.prototype.remove = VarStoreRemove;
VarStore.prototype.removeValue = VarStoreRemove;
VarStore.prototype.getValue = VarStoreGet;
VarStore.prototype.setValue = VarStoreSetValue;
VarStore.prototype.tokenExists = VarStoreTokenExists;
VarStore.prototype.toString = VarStoreToString;
VarStore.prototype.toHTML = VarStoreToHTML;

function VarStoreToHTML()
{
	return this.hashTable.toHTML();
}

function VarStoreGet(tok)
{
	tok = tok + "";
	return this.hashTable.get(tok);
}

function VarStoreRemove(tok)
{
	tok = tok + "";
	
	if (this.hashTable.remove(tok))
	{
		this.dirty = true;
		return true;
	}
	return false;
}

function VarStoreClear()
{
	if (this.hashTable.clear())
	{
		this.dirty = true;
		return true;
	}
	return false;
}

function VarStoreGetLength()
{
	return this.hashTable.getLength();
}

function VarStoreDump()
{
	var ht = this.hashTable;
	var retVal = "";
	var count = 0;
	for (var i in ht.obj)
	{
		if (ht.obj[i])
		{
			retVal += ((count++==0)?"":this.separator1) + i + this.separator2 + ht.obj[i];
		}
	}
	this.dirty = false;
	return retVal;
}

function VarStoreLoad(str)
{
	if (str == null) str = "";
	var pair = "";
	var separatorPosition = -1;
	
	//Strip token|value pairs off str one at a time.
	while ( (separatorPosition = str.indexOf(this.separator1)) != -1 )
	{
		//temp <- next pair
		pair = str.slice(0,separatorPosition);
		//str <- (str - next pair)
		str = str.slice(separatorPosition+1,str.length);
		
		//Now that we have isolated a token|value pair
		//strip out the token and value, and add them
		//to this objects storage.
		separatorPosition = pair.indexOf(this.separator2);
		if (separatorPosition == -1)
		{
			alert("Error in call to VarStore::load()\n"+str+" is an invalid token" + this.separator2 + "value pair. VarStore will be cleared.");
			this.clear();
			return false;
		}
		this.setValue( pair.slice(0,separatorPosition), pair.slice(separatorPosition+1,pair.length) );
	}
	
	//At this point we have at most one pair left,
	//and at least none.
	if (str != "")
	{
		separatorPosition = str.indexOf(this.separator2);
		if (separatorPosition == -1)
		{
			alert("Error in call to VarStore::load()\n"+str+" is an invalid token" + this.separator2 + "value pair. VarStore will be cleared.");
			this.clear();
			return false;
		}
		this.setValue( str.slice(0,separatorPosition), str.slice(separatorPosition+1,str.length) );
	}
	
	//If processing gets this far, then load was successful.
	this.dirty = false;
	return true;
}

function VarStoreSetValue(tok,val)
{
	//Check for reserved characters
	if ( ((tok+"").indexOf(this.separator1) != -1) || ((tok+"").indexOf(this.separator2) != -1) || ((val+"").indexOf(this.separator1) != -1) || ((val+"").indexOf(this.separator2) != -1) )
	{
		alert("Error in call to VarStore::setValue()\n'" + this.separator1 + "' and '" + this.separator2 + "' are reserved characters and cannot be used as a token name or value.\n\ntoken: " + tok + "\nvalue: " + val);
		return false;
	}
	if (this.hashTable.put(tok + "", val))
	{
		this.dirty = true;
		return true;
	}
	return false;
}

function VarStoreTokenExists(tok)
{
	tok = tok + "";
	return (this.hashTable.get(tok) != null);
}

function VarStoreToString()
{
	return this.hashTable.toString();
}

//---------------------------------------------------------------------------
//	JavaScript Binary Tree Constructor.
//
//	Usage:
//		tree = new Tree()
//	Methods:
//		void tree.insert(key,data)
//			The 'key' arguments will usually be an integer.
//			The 'data' arguments may be of any typeof().
//		void tree.remove(key)
//		object tree.find(key)
//			returns data object.
//		tree.in_order('function')	: note - not 'function()'
//		tree.pre_order('function')
//		tree.post_order('function')
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
function Node(parent,key,data) {
	this.parent	= parent;
	this.key	= key;
	this.data	= data;
	this.lft	= null;
	this.rgt	= null;
}

function Tree() {
	this.root = null;
}
//----------------------------------------------
// Public Functions.
//----------------------------------------------
Tree.prototype.insert = Tree_insert;
Tree.prototype.remove = Tree_remove;
Tree.prototype.find = Tree_find;
Tree.prototype.in_order = new Function('if(this.root) this.in_order_rec(this.root,arguments[0])');
Tree.prototype.pre_order = new Function('if(this.root) this.pre_order_rec(this.root,arguments[0])');
Tree.prototype.post_order = new Function('if(this.root) this.post_order_rec(this.root,arguments[0])');
//----------------------------------------------
// Private Functions.
//----------------------------------------------
Tree.prototype.in_order_rec	= Tree_in_order_rec;
Tree.prototype.pre_order_rec	= Tree_pre_order_rec;
Tree.prototype.post_order_rec	= Tree_post_order_rec;

function Tree_insert(key,data) {
	var current	= this.root;
	var parent	= null;
	/* find future parent */
	while(current) {
		if(key==current.key) // Duplicate key!
		{
			current.data = data;
			return true;
		}
		parent	= current;
		current	= (key<current.key) ? current.lft : current.rgt;
	}
	/* declare node */
	var x = new Node(parent,key,data);
	/* insert into tree */
	if(parent)
		if(x.key<parent.key)
			parent.lft = x;
		else	parent.rgt = x;
	else
		this.root = x;

	return true;
}
function Tree_remove(key) {
	var x,y	= null;
	var z	= this.root;
	/* find node in tree */
	while(z!=null) {
		if(key==z.key)	break;
		else z = (key < z.key) ? z.lft : z.rgt;
	}
	if(!z)	return false; // Key not found!
	/* find tree successor */
	if(z.lft==null||z.rgt==null)
		y = z;
	else {
		y = z.rgt;
		while(y.lft!=null)
			y = y.lft;
	}
	/* x is y's only child */
	if(y.lft!=null)
		x = y.lft;
	else	x = y.rgt;
	/* remove y from the parent chain */
	if(x)
		x.parent = y.parent;
	if(y.parent)
		if(y==y.parent.lft)
			y.parent.lft = x;
		else	y.parent.rgt = x;
	else
		this.root = x;
	/* if z and y are not the same, replace z with y. */
	if(y!=z) {
		y.lft = z.lft;
		if(y.lft)
			y.lft.parent = y;
		y.rgt = z.rgt;
		if(y.rgt)
			y.rgt.parent = y;
		y.parent = z.parent;
		if(z.parent)
			if(z==z.parent.lft)
				z.parent.lft = y;
			else	z.parent.rgt = y;
		else
			this.root = y;
		delete(z);
	} else
		delete(y);
		
	return true;
}
function Tree_find(key) {
	var current = this.root;
	while(current!=null) {
		if(key==current.key)
			return current.data;
		else	current = (key<current.key) ? current.lft : current.rgt;
	}
	return null; // Key not found!
}
function Tree_in_order_rec(node,fn) {
	if(node.lft) this.in_order_rec(node.lft,fn);
	eval(fn+'(node.key)');
	if(node.rgt) this.in_order_rec(node.rgt,fn);
}
function Tree_pre_order_rec(node,fn) {
	eval(fn+'(node.key)');
	if(node.lft) this.pre_order_rec(node.lft,fn);
	if(node.rgt) this.pre_order_rec(node.rgt,fn);
}
function Tree_post_order_rec(node,fn) {
	if(node.lft) this.post_order_rec(node.lft,fn);
	if(node.rgt) this.post_order_rec(node.rgt,fn);
	eval(fn+'(node.key)');
}
//---------------------------------------------------------------------------
//	End of Binary Tree Constructor.
//---------------------------------------------------------------------------

//////////////
// Glossary //
//////////////
function Glossary()
{
	this.counter = 0;
	this.dataArray = new Array();
	for (var i=0;i<27;i++)
	{
		this.dataArray[i] = new Tree();
	}
}
Glossary.prototype.insert = GlossaryInsert;
Glossary.prototype.remove = GlossaryRemove;
Glossary.prototype.retrieve = GlossaryRetrieve;
Glossary.prototype.getCount = GlossaryGetCount;
Glossary.prototype.getList = GlossaryGetList;

function GlossaryGetCount()
{
	return this.counter;
}

var glossaryRetArray;
function GlossaryGetList(letter)
{
	glossaryRetArray = new Array();
	if (letter == null)
	{
		for (var i=0;i<26;i++)
		{
			this.dataArray[i].in_order("addToArray");
		}
	}
	else if (letter == "*")
	{
		this.dataArray[26].in_order("addToArray");
	}
	else
	{
		var index = letter.toLowerCase().charCodeAt(0) - 97;
		this.dataArray[index].in_order("addToArray");
	}
	
	return glossaryRetArray;
}

function addToArray(term)
{
	glossaryRetArray[glossaryRetArray.length] = term;
}

function GlossaryInsert(term, def)
{
	var index = term.toLowerCase().charCodeAt(0);
	
	if (index < 97 || index > 122)
	{
		index = 26;
	}
	else
	{
		index -= 97;
	}
	
	if (this.dataArray[index].find(term) == null)
	{
		this.counter++;
	}
	this.dataArray[index].insert(term, def)
}

function GlossaryRemove(term)
{
	var index = term.toLowerCase().charCodeAt(0);
	
	if (index < 97 || index > 122)
	{
		index = 26;
	}
	else
	{
		index -= 97;
	}
	
	if (this.dataArray[index].find(term) != null)
	{
		this.dataArray[index].remove(term);
		this.counter--;
	}
}

function GlossaryRetrieve(term)
{
	var index = term.toLowerCase().charCodeAt(0);
	
	if (index < 97 || index > 122)
	{
		index = 26;
	}
	else
	{
		index -= 97;
	}

	return this.dataArray[index].find(term);
}

/////////
// Bag //
/////////
function Bag()
{
	this.valArray = new Array();
}
Bag.prototype.insert = function (obj) {this.valArray[this.valArray.length]=obj};
Bag.prototype.peek = function () {return this.valArray[Math.round(Math.random()*(this.valArray.length-1))]};
Bag.prototype.remove = function () {var index=Math.round(Math.random()*(this.valArray.length-1));var retVal=this.valArray[index];_Splice(this.valArray,index,1);return retVal};
Bag.prototype.getLength = function () {return this.valArray.length};
